package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.ReporteDiario;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;

import java.util.ArrayList;

public class ReporteDiarioAdapter extends RecyclerView.Adapter<ReporteDiarioAdapter.ReporteDiarioViewHolder>{

    Context context;
    public ArrayList<ReporteDiario> reportes;
    public ArrayList<ReporteDiario> reportesSeleccionados = new ArrayList<>();
    public ArrayList<ReporteDiario> reportesEditados = new ArrayList<>();

    public boolean buscarReporte = false;

    public ReporteDiarioAdapter(Context context,ArrayList<ReporteDiario> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    public void setBuscarReporte(boolean buscarReporte){
        this.buscarReporte = buscarReporte;
    }


    @NonNull
    @Override
    public ReporteDiarioAdapter.ReporteDiarioViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.reporte_diario_item, parent, false);
        return new ReporteDiarioAdapter.ReporteDiarioViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReporteDiarioAdapter.ReporteDiarioViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public void clear() {
        reportes.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteDiario> list) {
        reportes = list;
        notifyDataSetChanged();
    }

    public void setListaFiltrada(ArrayList<ReporteDiario>filteredList){
        this.reportes = filteredList;
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return reportes.size();
    }

    public class ReporteDiarioViewHolder extends RecyclerView.ViewHolder {

        TextView tvPoblacion, tvEstimado;

        ConstraintLayout reporte_diario_item_bg;

        Button btnVerPagos;

        public ReporteDiarioViewHolder(@NonNull View itemView) {
            super(itemView);

            tvPoblacion = itemView.findViewById(R.id.tvPoblacion);
            tvEstimado = itemView.findViewById(R.id.tvEstimado);
            btnVerPagos = itemView.findViewById(R.id.btnVerPagos);
            reporte_diario_item_bg = itemView.findViewById(R.id.reporte_diario_item_bg);


        }

        public void imprimir(int position) {

            tvPoblacion.setText(reportes.get(position).getNombre_poblacion());
            tvEstimado.setText("$"+(reportes.get(position).getEstimacion() != null && !reportes.get(position).getEstimacion().equals("") ? reportes.get(position).getEstimacion(): reportes.get(position).getEstimado()));

            if(reportes.get(position).getSeleccionado()){
                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));

                if(!buscarReporte){

                    reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                        @Override
                        public boolean onLongClick(View view) {
                            reportes.get(position).setSeleccionado(false);
                            reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                            reportesSeleccionados.remove(reportes.get(position));
                            return false;
                        }
                    });

                }

            }
            else{
                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
            }


            btnVerPagos.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_reporte_diario_rutas, null, false);

                    final int[] total1 = {0};
                    final int[] total2 = {0};
                    final int[] saldo = {0};

                    TextInputLayout tlEstimacion = dialogView.findViewById(R.id.tlEstimacion);
                    tlEstimacion.getEditText().setText((reportes.get(position).getEstimacion() != null && !reportes.get(position).getEstimacion().equals("") ? reportes.get(position).getEstimacion(): reportes.get(position).getEstimado()));
                    TextInputLayout tlAbonosSemana= dialogView.findViewById(R.id.tlAbonosSemana);
                    tlAbonosSemana.getEditText().setText(reportes.get(position).getAbonos_semana());
                    TextInputLayout tlRecupSemana = dialogView.findViewById(R.id.tlRecupSemana);
                    tlRecupSemana.getEditText().setText(reportes.get(position).getRecuperacion_semana());
                    TextInputLayout tlAnticipos = dialogView.findViewById(R.id.tlAnticipos);
                    tlAnticipos.getEditText().setText(reportes.get(position).getAnticipos());
                    TextInputLayout tlTotal1 = dialogView.findViewById(R.id.tlTotal1);
                    tlTotal1.getEditText().setText(reportes.get(position).getTotal_1());
                    TextInputLayout tlRecupPrestamos = dialogView.findViewById(R.id.tlRecupPrestamos);
                    tlRecupPrestamos.getEditText().setText(reportes.get(position).getRecuperacion_prestamos());
                    TextInputLayout tlColocacion = dialogView.findViewById(R.id.tlColocacion);
                    tlColocacion.getEditText().setText(reportes.get(position).getColocacion());
                    TextInputLayout tlPrestamoColocadora = dialogView.findViewById(R.id.tlPrestamoColocadora);
                    tlPrestamoColocadora.getEditText().setText(reportes.get(position).getPrestamo_colocadora());
                    TextInputLayout tlComision = dialogView.findViewById(R.id.tlComision);
                    tlComision.getEditText().setText(reportes.get(position).getComision());
                    TextInputLayout tlBonoColocadora = dialogView.findViewById(R.id.tlBonoColocadora);
                    tlBonoColocadora.getEditText().setText(reportes.get(position).getBono_colocadora());
                    TextInputLayout tlTotal2 = dialogView.findViewById(R.id.tlTotal2);
                    tlTotal2.getEditText().setText(reportes.get(position).getTotal_2());
                    TextInputLayout tlSaldo = dialogView.findViewById(R.id.tlSaldo);
                    tlSaldo.getEditText().setText(reportes.get(position).getSaldo());
                    TextInputLayout tlPendienteRecup = dialogView.findViewById(R.id.tlPendienteRecup);
                    tlPendienteRecup.getEditText().setText(reportes.get(position).getPendiente_recuperar());
                    TextInputLayout tlAbonosRecup = dialogView.findViewById(R.id.tlAbonosRecup);
                    tlAbonosRecup.getEditText().setText(reportes.get(position).getAbonos_recuperar());

                    tlRecupSemana.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total1[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlAnticipos.getEditText().getText().toString().equals("") ? "0" : tlAnticipos.getEditText().getText().toString()));

                            tlTotal1.getEditText().setText(String.valueOf(total1[0]));

                        }
                    });

                    tlAnticipos.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total1[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlRecupSemana.getEditText().getText().toString().equals("") ? "0" : tlRecupSemana.getEditText().getText().toString()));

                            tlTotal1.getEditText().setText(String.valueOf(total1[0]));

                        }
                    });


                    tlColocacion.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                    + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()))
                                    + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                            tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                        }
                    });

                    tlPrestamoColocadora.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                    + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()))
                                    + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                            tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                        }
                    });

                    tlComision.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                    + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                    + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                            tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                        }
                    });

                    tlBonoColocadora.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                    + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                    + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()));

                            tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                        }
                    });

                    /*tlTotal1.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            saldo[0] = Integer.parseInt((tlTotal2.getEditText().getText().toString().equals("") ? "0" : tlTotal2.getEditText().getText().toString()))
                            - Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()));

                            tlSaldo.getEditText().setText(String.valueOf(saldo[0]));

                        }
                    });*/

                    tlTotal2.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            saldo[0] = Integer.parseInt((tlTotal1.getEditText().getText().toString().equals("") ? "0" : tlTotal1.getEditText().getText().toString()))
                                    - Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()));

                            tlSaldo.getEditText().setText(String.valueOf(saldo[0]));

                        }
                    });


                    new MaterialAlertDialogBuilder(context)
                            .setCancelable(false)
                            .setView(dialogView)
                            .setTitle(reportes.get(position).getNombre_poblacion())
                            .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {

                                    if(!buscarReporte){

                                        reportes.get(position).setSeleccionado(true);
                                        reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                                        if(!reportesSeleccionados.contains(reportes.get(position))){
                                            reportesSeleccionados.add(reportes.get(position));
                                        }

                                        reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                                            @Override
                                            public boolean onLongClick(View view) {
                                                reportes.get(position).setSeleccionado(false);
                                                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                                                reportesSeleccionados.remove(reportes.get(position));
                                                return false;
                                            }
                                        });

                                    }

                                    reportes.get(position).setEstimacion(tlEstimacion.getEditText().getText().toString());
                                    reportes.get(position).setAbonos_semana(tlAbonosSemana.getEditText().getText().toString());
                                    reportes.get(position).setRecuperacion_semana(tlRecupSemana.getEditText().getText().toString());
                                    reportes.get(position).setAnticipos(tlAnticipos.getEditText().getText().toString());
                                    reportes.get(position).setTotal_1(tlTotal1.getEditText().getText().toString());
                                    reportes.get(position).setRecuperacion_prestamos(tlRecupPrestamos.getEditText().getText().toString());
                                    reportes.get(position).setColocacion(tlColocacion.getEditText().getText().toString());
                                    reportes.get(position).setPrestamo_colocadora(tlPrestamoColocadora.getEditText().getText().toString());
                                    reportes.get(position).setComision(tlComision.getEditText().getText().toString());
                                    reportes.get(position).setBono_colocadora(tlBonoColocadora.getEditText().getText().toString());
                                    reportes.get(position).setTotal_2(tlTotal2.getEditText().getText().toString());
                                    reportes.get(position).setSaldo(tlSaldo.getEditText().getText().toString());
                                    reportes.get(position).setPendiente_recuperar(tlPendienteRecup.getEditText().getText().toString());
                                    reportes.get(position).setAbonos_recuperar(tlAbonosRecup.getEditText().getText().toString());

                                    if(buscarReporte){
                                        reportesEditados.add(reportes.get(position));
                                    }

                                }
                            })
                            .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {

                                }
                            })
                            .show();

                }
            });

        }
    }
}